Project Name
============

_Project overview image here, if possible_

_Short, one to two line project description._
 
This code has been developed by [ZKM | Hertz-Lab](https://zkm.de/en/about-the-zkm/organization/hertz-lab) as part of the project [»The Intelligent Museum«](#the-intelligent-museum).

Copyright (c) 2021 ZKM | Karlsruhe.
Copyright (c) 2021 Artist Developer.

For information on usage and redistribution, and for a DISCLAIMER OF ALL
WARRANTIES, see the file, "LICENSE.txt," in this distribution.

BSD Simplified License.

Description
-----------

_Detailed project description. Don't forget to include relevant attribution for forked, adapted, or inspired projects._

### Structure

_List repo folder structure for larger, more complicated projects_

* folder1/: contains models
* folder2/: contains media assets
* etc...

Requirements
------------

(Software) dependencies:
* libA
* libB
* etc...

Operating systems/platforms:
* macOS
* Linux
* Windows
* etc...

_Add any notes about which platforms or setups were used for development & testing._

Installation & Build
--------------------

_General dependency & build install instructions with per-platform subsections when needed. Please include commandline steps, when applicable._

Download and Install [Anaconda](https://www.anaconda.com/products/individual). Afterwards create a virtual environment:

```shell
$ conda create -n "name" python=3.7
$ conda activate "name"
$ pip install -r requirements.txt
```

Usage
-----

_Usage instructions for when the application is built and installed._

#### Show Help
```
$ python executable.py --help
```

#### scenario 1
```
$ python executable.py --parameter 42
```

References / Further Reading
----------------------------

_List useful references, related projects, or papers here._

* [paper](www.google.com)
* [paper2](www.google.com)

Contribute
----------

Contributions are very welcome! Clone or fork the repo, then request a pull / merge.

If you find any bugs or suggestions please log them here as well.

The Intelligent Museum
----------------------

An artistic-curatorial field of experimentation for deep learning and visitor participation

The [ZKM | Center for Art and Media](https://zkm.de/en) and the [Deutsches Museum Nuremberg](https://www.deutsches-museum.de/en/nuernberg/information/) cooperate with the goal of implementing an AI-supported exhibition. Together with researchers and international artists, new AI-based works of art will be realized during the next four years (2020-2023).  They will be embedded in the AI-supported exhibition in both houses. The Project „The Intelligent Museum” is funded by the Digital Culture Programme of the [Kulturstiftung des Bundes](https://www.kulturstiftung-des-bundes.de/en) (German Federal Cultural Foundation) and funded by the [Beauftragte der Bundesregierung für Kultur und Medien](https://www.bundesregierung.de/breg-de/bundesregierung/staatsministerin-fuer-kultur-und-medien) (Federal Government Commissioner for Culture and the Media).

As part of the project, digital curating will be critically examined using various approaches of digital art. Experimenting with new digital aesthetics and forms of expression enables new museum experiences and thus new ways of museum communication and visitor participation. The museum is transformed to a place of experience and critical exchange.

![Logo](media/Logo_ZKM_DMN_KSB.png)
